<?php
/* --------------------------------------------------------------
 DoctrineQbServiceProvider.php 2020-01-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\ServiceProviders;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\DriverManager;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use TestsConfig;
use function file_exists;
use function file_get_contents;
use function preg_match_all;

/**
 * Class DoctrineQbServiceProvider
 * @package Gambio\Core\ServiceProvider
 */
class DoctrineQbServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            Connection::class
        ];
    }
    
    
    /**
     * @inheritDoc
     * @throws DBALException
     */
    public function register(): void
    {
        $config = $this->getDatabaseConfig();
        $dbHost = $config['DB_SERVER'];
        $dbUser = $config['DB_SERVER_USERNAME'];
        $dbName = $config['DB_DATABASE'];
        $dbPass = $config['DB_SERVER_PASSWORD'] === '' ? '' : ':' . urlencode($config['DB_SERVER_PASSWORD']);
        
        $dsn = "pdo-mysql://$dbUser$dbPass@$dbHost/$dbName?charset=UTF8";
        
        $this->application->share(Connection::class, DriverManager::getConnection(['url' => $dsn]));
    }
    
    
    /**
     * @return array
     */
    private function getDatabaseConfig(): array
    {
        $config           = [];
        $configureContent = file_get_contents(__DIR__ . '/../../../includes/configure.php');
        preg_match_all("/define\('(DB_\w*)',\s?'(.*)'\);/m", $configureContent, $matches);
        
        foreach ($matches[1] as $index => $key) {
            $config[$key] = $matches[2][$index];
        }
        
        if (count($config) === 0) {
            return $this->testsConfigFallback();
        }
        
        return $config;
    }
    
    
    /**
     * @return array
     */
    private function testsConfigFallback(): array
    {
        if (file_exists($testsConfig = __DIR__ . '/../../../../tests/tests.config.inc.php')) {
            require_once $testsConfig;
            
            return [
                'DB_SERVER'          => TestsConfig::DB_HOST,
                'DB_SERVER_USERNAME' => TestsConfig::DB_USER,
                'DB_SERVER_PASSWORD' => TestsConfig::DB_PASSWORD,
                'DB_DATABASE'        => TestsConfig::DB_NAME,
            ];
        }
        
        return [
            'DB_SERVER'          => '',
            'DB_SERVER_USERNAME' => '',
            'DB_SERVER_PASSWORD' => '',
            'DB_DATABASE'        => '',
        ];
    }
}